<?php
$DB_CONFIG = [
  'host' => '127.0.0.1',
  'dbname' => 'probashi_italian',
  'username' => 'root',
  'password' => '',
  'charset' => 'utf8mb4',
];

function getDB(): PDO {
    global $DB_CONFIG;
    static $pdo = null;
    if ($pdo === null) {
        $dsn = "mysql:host={$DB_CONFIG['host']};dbname={$DB_CONFIG['dbname']};charset={$DB_CONFIG['charset']}";
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ];
        $pdo = new PDO($dsn, $DB_CONFIG['username'], $DB_CONFIG['password'], $options);
    }
    return $pdo;
}