<?php
require_once __DIR__ . '/../../core/functions.php';
$pdo = getDB();
$method = $_SERVER['REQUEST_METHOD'];
$route  = isset($_GET['__route']) ? trim($_GET['__route'], '/') : '';

// GET /api/v1/rewards/leaderboard (Protected)
if ($method === 'GET' && $route === 'leaderboard') {
    $user = authUser($pdo);
    $period = $_GET['period'] ?? 'all_time';
    if ($period === 'weekly') {
        $stmt = $pdo->query("SELECT u.id,u.name,COALESCE(SUM(p.points),0) AS total_points
                             FROM users u
                             LEFT JOIN user_points p ON p.user_id=u.id AND YEARWEEK(p.created_at,1)=YEARWEEK(CURDATE(),1)
                             GROUP BY u.id ORDER BY total_points DESC LIMIT 50");
    } else {
        $stmt = $pdo->query("SELECT u.id,u.name,COALESCE(SUM(p.points),0) AS total_points
                             FROM users u
                             LEFT JOIN user_points p ON p.user_id=u.id
                             GROUP BY u.id ORDER BY total_points DESC LIMIT 50");
    }
    jsonResponse(true,'OK',[ 'leaders'=>$stmt->fetchAll() ]);
}

// GET /api/v1/rewards/history (Protected)
if ($method === 'GET' && $route === 'history') {
    $user = authUser($pdo);
    $stmt = $pdo->prepare("SELECT id,points,reason,created_at FROM user_points WHERE user_id=? ORDER BY id DESC LIMIT 1000");
    $stmt->execute([(int)$user['id']]);
    jsonResponse(true,'OK',[ 'history'=>$stmt->fetchAll() ]);
}

// POST /api/v1/rewards/request_payout (Protected)
if ($method === 'POST' && $route === 'request_payout') {
    $user = authUser($pdo);
    $in = getInputJSON();
    $rechargeNumber = sanitize($in['recharge_number'] ?? '');
    $pointsToRedeem = (int)($in['points_to_redeem'] ?? 0);
    if (!$rechargeNumber || $pointsToRedeem <= 0) jsonResponse(false,'Invalid input');
    $current = userTotalPoints($pdo,(int)$user['id']);
    if ($current < $pointsToRedeem) jsonResponse(false,'Insufficient points');
    $pointsPerTaka = (int)getAppSetting($pdo,'points_per_recharge_taka',100);
    $amount = round($pointsToRedeem / max($pointsPerTaka,1), 2);
    $pdo->beginTransaction();
    try {
        addUserPoints($pdo,(int)$user['id'],-$pointsToRedeem,'Payout request');
        $pdo->prepare("INSERT INTO payout_requests (user_id,points_used,recharge_number,recharge_amount) VALUES (?,?,?,?)")
            ->execute([(int)$user['id'],$pointsToRedeem,$rechargeNumber,$amount]);
        $pdo->commit();
        jsonResponse(true,'Payout requested',[ 'recharge_amount'=>$amount ]);
    } catch (Exception $e) {
        $pdo->rollBack();
        jsonResponse(false,'Failed to request payout');
    }
}

jsonResponse(false,'Route not found',null,404);