<?php
require_once __DIR__ . '/../../core/functions.php';
$pdo = getDB();
$method = $_SERVER['REQUEST_METHOD'];
$route  = isset($_GET['__route']) ? trim($_GET['__route'], '/') : '';

// POST /api/v1/quizzes/submit (Protected)
if ($method === 'POST' && $route === 'submit') {
    $user = authUser($pdo);
    $in = getInputJSON();
    $quizId = (int)($in['quiz_id'] ?? 0);
    $score  = (int)($in['score'] ?? 0);
    if ($quizId <= 0 || $score < 0) jsonResponse(false, 'Invalid input');
    $pdo->beginTransaction();
    try {
        $pdo->prepare("INSERT INTO user_quiz_attempts (user_id, quiz_id, score) VALUES (?,?,?)")
            ->execute([(int)$user['id'],$quizId,$score]);
        $earned = $score * 10; // simple rule
        addUserPoints($pdo, (int)$user['id'], $earned, 'Quiz #'.$quizId.' score='.$score);
        $pdo->commit();
        $newTotal = userTotalPoints($pdo,(int)$user['id']);
        jsonResponse(true,'Quiz recorded',[ 'points_earned'=>$earned, 'total_points'=>$newTotal ]);
    } catch (Exception $e) {
        $pdo->rollBack();
        jsonResponse(false,'Failed to record quiz');
    }
}

// GET /api/v1/quizzes/advanced (Protected)
if ($method === 'GET' && $route === 'advanced') {
    $user = authUser($pdo);
    $moduleId = isset($_GET['module_id']) ? (int)$_GET['module_id'] : null;
    $sql = "SELECT q.id,q.title,q.is_pro_only FROM quizzes q WHERE q.is_active=1";
    $args = [];
    if ($moduleId) { $sql .= " AND q.module_id=?"; $args[] = $moduleId; }
    if (!(int)$user['is_pro_subscriber']) { $sql .= " AND q.is_pro_only=0"; }
    $sql .= " ORDER BY q.sort_order ASC,q.id DESC LIMIT 200";
    $stmt = $pdo->prepare($sql); $stmt->execute($args);
    jsonResponse(true,'OK',[ 'quizzes'=>$stmt->fetchAll() ]);
}

jsonResponse(false,'Route not found',null,404);