<?php
require_once __DIR__ . '/../../core/functions.php';
$pdo = getDB();
$method = $_SERVER['REQUEST_METHOD'];
$route  = isset($_GET['__route']) ? trim($_GET['__route'], '/') : '';

// GET /api/v1/modules (public)
if ($method === 'GET' && $route === '') {
    $stmt = $pdo->query("SELECT id,module_title_bn,cefr_level,sort_order FROM modules ORDER BY sort_order ASC, id ASC");
    jsonResponse(true,'OK',[ 'modules'=>$stmt->fetchAll() ]);
}

// GET /api/v1/modules/lessons?module_id=1 (public)
if ($method === 'GET' && $route === 'lessons') {
    $moduleId = (int)($_GET['module_id'] ?? 0);
    if ($moduleId <= 0) jsonResponse(false,'Invalid module_id');
    $stmt = $pdo->prepare("SELECT id,lesson_title_bn,sort_order FROM lessons WHERE module_id=? ORDER BY sort_order ASC, id ASC");
    $stmt->execute([$moduleId]);
    jsonResponse(true,'OK',[ 'lessons'=>$stmt->fetchAll() ]);
}

jsonResponse(false,'Route not found',null,404);