<?php
require_once __DIR__ . '/../../core/functions.php';
$pdo = getDB();
$method = $_SERVER['REQUEST_METHOD'];
$route  = isset($_GET['__route']) ? trim($_GET['__route'], '/') : '';

// GET /api/v1/content/lesson?lesson_id=123 (public)
if ($method === 'GET' && $route === 'lesson') {
    $lessonId = (int)($_GET['lesson_id'] ?? 0);
    if ($lessonId <= 0) jsonResponse(false,'Invalid lesson_id');
    $stmt = $pdo->prepare("SELECT id,lesson_id,item_type,text_italian,text_bengali,pronunciation_bengali,context_note,audio_url,image_url,created_at FROM content_items WHERE lesson_id=? ORDER BY id ASC");
    $stmt->execute([$lessonId]);
    jsonResponse(true,'OK',[ 'items'=>$stmt->fetchAll() ]);
}

// GET /api/v1/content/by-module?module_id=1 (public, convenience)
if ($method === 'GET' && $route === 'by-module') {
    $moduleId = (int)($_GET['module_id'] ?? 0);
    if ($moduleId <= 0) jsonResponse(false,'Invalid module_id');
    $sql = "SELECT ci.* FROM content_items ci JOIN lessons l ON l.id=ci.lesson_id WHERE l.module_id=? ORDER BY l.sort_order ASC, ci.id ASC";
    $stmt = $pdo->prepare($sql); $stmt->execute([$moduleId]);
    jsonResponse(true,'OK',[ 'items'=>$stmt->fetchAll() ]);
}

jsonResponse(false,'Route not found',null,404);