<?php
require_once __DIR__ . '/../core/functions.php';
require_once __DIR__ . '/includes/auth_check.php';
include __DIR__ . '/includes/header.php';
$pdo = getDB();

$search = trim($_GET['q'] ?? '');
if ($search) {
  $stmt = $pdo->prepare("SELECT * FROM users WHERE name LIKE ? OR email LIKE ? ORDER BY id DESC LIMIT 200");
  $stmt->execute(['%'.$search.'%', '%'.$search.'%']);
} else {
  $stmt = $pdo->query("SELECT * FROM users ORDER BY id DESC LIMIT 200");
}
$users = $stmt->fetchAll();

// Handle point adjustments & pro toggle
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (isset($_POST['adjust_points'])) {
    $userId = (int)$_POST['user_id'];
    $delta  = (int)$_POST['points_delta'];
    addUserPoints($pdo, $userId, $delta, 'Manual adjustment');
    echo '<div class="alert alert-success">Points updated.</div>';
  }
  if (isset($_POST['set_pro'])) {
    $userId = (int)$_POST['user_id'];
    $isPro  = (int)$_POST['is_pro_subscriber'];
    $expiry = $_POST['pro_expiry_date'] ?: null;
    $stmt = $pdo->prepare("UPDATE users SET is_pro_subscriber=?, pro_expiry_date=? WHERE id=?");
    $stmt->execute([$isPro, $expiry, $userId]);
    echo '<div class="alert alert-success">Pro status updated.</div>';
  }
}
?>
<h3 class="mb-3">Users</h3>
<form class="row g-2 mb-3">
  <div class="col-auto"><input class="form-control" type="text" name="q" placeholder="Search name/email" value="<?php echo htmlspecialchars($search); ?>"></div>
  <div class="col-auto"><button class="btn btn-primary">Search</button></div>
</form>

<table class="table table-striped">
  <thead><tr><th>ID</th><th>Name</th><th>Email</th><th>Pro</th><th>Total Points</th><th>Actions</th></tr></thead>
  <tbody>
  <?php foreach ($users as $u): ?>
    <?php $tp = userTotalPoints($pdo, (int)$u['id']); ?>
    <tr>
      <td><?php echo $u['id']; ?></td>
      <td><?php echo htmlspecialchars($u['name']); ?></td>
      <td><?php echo htmlspecialchars($u['email']); ?></td>
      <td><?php echo $u['is_pro_subscriber'] ? 'Yes' : 'No'; ?></td>
      <td><?php echo $tp; ?></td>
      <td>
        <form method="post" class="d-flex gap-2">
          <input type="hidden" name="user_id" value="<?php echo $u['id']; ?>">
          <input class="form-control" style="max-width:120px" type="number" name="points_delta" placeholder="±points">
          <button class="btn btn-sm btn-outline-primary" name="adjust_points">Apply</button>
        </form>
        <form method="post" class="d-flex gap-2 mt-2">
          <input type="hidden" name="user_id" value="<?php echo $u['id']; ?>">
          <select class="form-select" name="is_pro_subscriber" style="max-width:120px">
            <option value="0" <?php echo !$u['is_pro_subscriber']?'selected':''; ?>>Free</option>
            <option value="1" <?php echo $u['is_pro_subscriber']?'selected':''; ?>>Pro</option>
          </select>
          <input class="form-control" type="date" name="pro_expiry_date" value="<?php echo htmlspecialchars($u['pro_expiry_date']); ?>" style="max-width:170px">
          <button class="btn btn-sm btn-outline-success" name="set_pro">Save</button>
        </form>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
<?php include __DIR__ . '/includes/footer.php'; ?>
