<?php
require_once __DIR__ . '/../core/functions.php';
require_once __DIR__ . '/includes/auth_check.php';
include __DIR__ . '/includes/header.php';
$pdo = getDB();

// Define the settings keys for app version and ads
$keys = ['android_latest_version', 'android_force_update', 'ads_enabled', 'points_per_recharge_taka', 'fcm_server_key'];

// Handle form submission for saving app settings
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  foreach ($keys as $key) {
    $value = $_POST[$key] ?? '';
    setAppSetting($pdo, $key, $value);
  }
  echo '<div class="alert alert-success">Settings saved successfully!</div>';
}

// Fetch the current values of all settings
$values = [];
foreach ($keys as $key) {
  $values[$key] = getAppSetting($pdo, $key, '');
}
?>
<h3 class="mb-3">App Settings</h3>
<form method="post" class="card card-body">
  <div class="row g-3">
    <!-- Android Latest Version -->
    <div class="col-md-6">
      <label class="form-label">Android Latest Version</label>
      <input class="form-control" name="android_latest_version" value="<?php echo htmlspecialchars($values['android_latest_version']); ?>">
    </div>
    
    <!-- Force Update Toggle -->
    <div class="col-md-3">
      <label class="form-label">Force Update (0/1)</label>
      <input class="form-control" name="android_force_update" value="<?php echo htmlspecialchars($values['android_force_update']); ?>">
    </div>
    
    <!-- Ads Enabled Toggle -->
    <div class="col-md-3">
      <label class="form-label">Ads Enabled (0/1)</label>
      <input class="form-control" name="ads_enabled" value="<?php echo htmlspecialchars($values['ads_enabled']); ?>">
    </div>
    
    <!-- Points per Recharge Taka -->
    <div class="col-md-4">
      <label class="form-label">Points per Taka</label>
      <input class="form-control" name="points_per_recharge_taka" value="<?php echo htmlspecialchars($values['points_per_recharge_taka']); ?>">
    </div>
    
    <!-- FCM Server Key -->
    <div class="col-md-8">
      <label class="form-label">FCM Server Key</label>
      <input class="form-control" name="fcm_server_key" value="<?php echo htmlspecialchars($values['fcm_server_key']); ?>">
    </div>
  </div>
  
  <!-- Submit Button -->
  <button class="btn btn-primary mt-3">Save Settings</button>
</form>

<?php include __DIR__ . '/includes/footer.php'; ?>
