<?php
require_once __DIR__ . '/../core/functions.php';
require_once __DIR__ . '/includes/auth_check.php';
include __DIR__ . '/includes/header.php';
$pdo = getDB();

// Handle leaderboard fetching for different periods
$period = $_GET['period'] ?? 'all_time';
$leaderboardQuery = "SELECT u.id, u.name, COALESCE(SUM(p.points),0) AS total_points
                     FROM users u
                     LEFT JOIN user_points p ON p.user_id = u.id";
if ($period === 'weekly') {
    $leaderboardQuery .= " AND YEARWEEK(p.created_at, 1) = YEARWEEK(CURDATE(), 1)";
}
$leaderboardQuery .= " GROUP BY u.id ORDER BY total_points DESC LIMIT 50";

$leaders = $pdo->query($leaderboardQuery)->fetchAll();

// Reward History
$rewardHistory = $pdo->query("SELECT r.id, r.user_id, r.points_used, r.recharge_number, r.recharge_amount, r.status, r.requested_at
                              FROM payout_requests r ORDER BY r.requested_at DESC")->fetchAll();
?>
<h3 class="mb-3">Rewards & Leaderboard</h3>

<!-- Leaderboard Section -->
<h4>Leaderboard</h4>
<p>Top 50 Users (<?php echo ucfirst($period); ?>)</p>
<table class="table table-striped">
  <thead>
    <tr><th>Rank</th><th>Name</th><th>Total Points</th></tr>
  </thead>
  <tbody>
    <?php $rank = 1; foreach ($leaders as $leader): ?>
      <tr>
        <td><?php echo $rank++; ?></td>
        <td><?php echo htmlspecialchars($leader['name']); ?></td>
        <td><?php echo $leader['total_points']; ?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>

<!-- Reward History Section -->
<h4 class="mt-5">Reward History</h4>
<table class="table table-striped">
  <thead>
    <tr><th>ID</th><th>User</th><th>Points Used</th><th>Recharge Number</th><th>Amount</th><th>Status</th><th>Requested</th></tr>
  </thead>
  <tbody>
    <?php foreach ($rewardHistory as $reward): ?>
      <tr>
        <td><?php echo $reward['id']; ?></td>
        <td><?php echo htmlspecialchars($reward['user_id']); ?></td>
        <td><?php echo $reward['points_used']; ?></td>
        <td><?php echo $reward['recharge_number']; ?></td>
        <td><?php echo number_format($reward['recharge_amount'], 2); ?></td>
        <td><?php echo $reward['status']; ?></td>
        <td><?php echo $reward['requested_at']; ?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>

<?php include __DIR__ . '/includes/footer.php'; ?>
