<?php
require_once __DIR__ . '/../core/functions.php';
require_once __DIR__ . '/includes/auth_check.php';
include __DIR__ . '/includes/header.php';
$pdo = getDB();

// Fetch modules to assign quizzes to
$modules = $pdo->query("SELECT id, module_title_bn FROM modules ORDER BY sort_order")->fetchAll();

// Handle form submissions for both creating and updating quizzes
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $quizTitle = sanitize($_POST['quiz_title'] ?? '');
  $moduleId = (int)($_POST['module_id'] ?? 0);
  $isProOnly = isset($_POST['is_pro_only']) ? 1 : 0;
  $isActive = isset($_POST['is_active']) ? 1 : 0;
  $sortOrder = (int)($_POST['sort_order'] ?? 0);

  if (!$quizTitle || $moduleId <= 0) {
    echo '<div class="alert alert-danger">Invalid input.</div>';
  } else {
    if (!empty($_POST['quiz_id'])) {
      // Update existing quiz
      $quizId = (int)$_POST['quiz_id'];
      $stmt = $pdo->prepare("UPDATE quizzes SET title = ?, module_id = ?, is_pro_only = ?, is_active = ?, sort_order = ? WHERE id = ?");
      $stmt->execute([$quizTitle, $moduleId, $isProOnly, $isActive, $sortOrder, $quizId]);
      echo '<div class="alert alert-success">Quiz updated.</div>';
    } else {
      // Create new quiz
      $stmt = $pdo->prepare("INSERT INTO quizzes (title, module_id, is_pro_only, is_active, sort_order) VALUES (?, ?, ?, ?, ?)");
      $stmt->execute([$quizTitle, $moduleId, $isProOnly, $isActive, $sortOrder]);
      echo '<div class="alert alert-success">Quiz created.</div>';
    }
  }
}

// Handle quiz deletion
if (isset($_GET['delete'])) {
  $quizId = (int)$_GET['delete'];
  $stmt = $pdo->prepare("DELETE FROM quizzes WHERE id = ?");
  $stmt->execute([$quizId]);
  echo '<div class="alert alert-danger">Quiz deleted.</div>';
}

// Fetch all quizzes with associated modules
$quizzes = $pdo->query("SELECT q.id, q.title, q.is_pro_only, q.is_active, q.sort_order, m.module_title_bn FROM quizzes q JOIN modules m ON q.module_id = m.id ORDER BY q.sort_order, q.id")->fetchAll();

// If editing a quiz, load the current data
if (isset($_GET['edit'])) {
    $quizId = (int)$_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM quizzes WHERE id = ? LIMIT 1");
    $stmt->execute([$quizId]);
    $quiz = $stmt->fetch();
    if (!$quiz) {
        echo '<div class="alert alert-danger">Quiz not found.</div>';
    } else {
        $quizTitle = $quiz['title'];
        $moduleId = $quiz['module_id'];
        $isProOnly = $quiz['is_pro_only'];
        $isActive = $quiz['is_active'];
        $sortOrder = $quiz['sort_order'];
    }
} else {
    // Default values for creating a new quiz
    $quizTitle = '';
    $moduleId = 0;
    $isProOnly = 0;
    $isActive = 1;
    $sortOrder = 0;
}
?>
<h3 class="mb-3"><?php echo isset($_GET['edit']) ? 'Edit Quiz' : 'Create Quiz'; ?></h3>

<!-- Quiz Form: For both creating and editing -->
<form method="post" class="mb-3">
  <?php if (isset($quiz)): ?>
    <input type="hidden" name="quiz_id" value="<?php echo $quiz['id']; ?>">
  <?php endif; ?>
  <div class="mb-3">
    <label class="form-label">Quiz Title</label>
    <input type="text" name="quiz_title" class="form-control" value="<?php echo htmlspecialchars($quizTitle); ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Module</label>
    <select name="module_id" class="form-control" required>
      <?php foreach ($modules as $module): ?>
        <option value="<?php echo $module['id']; ?>" <?php echo $module['id'] === $moduleId ? 'selected' : ''; ?>>
          <?php echo htmlspecialchars($module['module_title_bn']); ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3 form-check">
    <input type="checkbox" name="is_pro_only" class="form-check-input" <?php echo $isProOnly ? 'checked' : ''; ?>>
    <label class="form-check-label">Pro Only</label>
  </div>
  <div class="mb-3 form-check">
    <input type="checkbox" name="is_active" class="form-check-input" <?php echo $isActive ? 'checked' : ''; ?>>
    <label class="form-check-label">Active</label>
  </div>
  <div class="mb-3">
    <label class="form-label">Sort Order</label>
    <input type="number" name="sort_order" class="form-control" value="<?php echo $sortOrder; ?>" required>
  </div>
  <button class="btn btn-primary"><?php echo isset($quiz) ? 'Save Quiz' : 'Create Quiz'; ?></button>
</form>

<!-- Quiz List -->
<table class="table table-striped">
  <thead>
    <tr><th>ID</th><th>Title</th><th>Module</th><th>Pro Only</th><th>Active</th><th>Sort Order</th><th>Actions</th></tr>
  </thead>
  <tbody>
    <?php foreach ($quizzes as $quiz): ?>
      <tr>
        <td><?php echo $quiz['id']; ?></td>
        <td><?php echo htmlspecialchars($quiz['title']); ?></td>
        <td><?php echo htmlspecialchars($quiz['module_title_bn']); ?></td>
        <td><?php echo $quiz['is_pro_only'] ? 'Yes' : 'No'; ?></td>
        <td><?php echo $quiz['is_active'] ? 'Yes' : 'No'; ?></td>
        <td><?php echo $quiz['sort_order']; ?></td>
        <td>
          <a class="btn btn-sm btn-outline-info" href="/admin/quizzes.php?edit=<?php echo $quiz['id']; ?>">Edit</a>
          <a class="btn btn-sm btn-outline-danger" href="/admin/quizzes.php?delete=<?php echo $quiz['id']; ?>">Delete</a>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php include __DIR__ . '/includes/footer.php'; ?>
