<?php
require_once __DIR__ . '/../core/functions.php';
require_once __DIR__ . '/includes/auth_check.php';
include __DIR__ . '/includes/header.php';
$pdo = getDB();

// Handle form submissions for both creating and updating modules
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $moduleTitle = sanitize($_POST['module_title'] ?? '');
  $cefrLevel = $_POST['cefr_level'] ?? '';
  $sortOrder = (int)($_POST['sort_order'] ?? 0);

  if (!$moduleTitle || !in_array($cefrLevel, ['A1', 'A2', 'B1', 'B2', 'C1', 'C2'])) {
    echo '<div class="alert alert-danger">Invalid input.</div>';
  } else {
    if (!empty($_POST['module_id'])) {
      // Update existing module
      $moduleId = (int)$_POST['module_id'];
      $stmt = $pdo->prepare("UPDATE modules SET module_title_bn = ?, cefr_level = ?, sort_order = ? WHERE id = ?");
      $stmt->execute([$moduleTitle, $cefrLevel, $sortOrder, $moduleId]);
      echo '<div class="alert alert-success">Module updated.</div>';
    } else {
      // Create new module
      $stmt = $pdo->prepare("INSERT INTO modules (module_title_bn, cefr_level, sort_order) VALUES (?, ?, ?)");
      $stmt->execute([$moduleTitle, $cefrLevel, $sortOrder]);
      echo '<div class="alert alert-success">Module created.</div>';
    }
  }
}

// Handle deletion of modules
if (isset($_GET['delete'])) {
  $moduleId = (int)$_GET['delete'];
  $stmt = $pdo->prepare("DELETE FROM modules WHERE id = ?");
  $stmt->execute([$moduleId]);
  echo '<div class="alert alert-danger">Module deleted.</div>';
}

// Fetch all modules for display
$modules = $pdo->query("SELECT * FROM modules ORDER BY sort_order, id")->fetchAll();

// If editing a module, load the current data
if (isset($_GET['edit'])) {
    $moduleId = (int)$_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM modules WHERE id = ? LIMIT 1");
    $stmt->execute([$moduleId]);
    $module = $stmt->fetch();
    if (!$module) {
        echo '<div class="alert alert-danger">Module not found.</div>';
    } else {
        $moduleTitle = $module['module_title_bn'];
        $cefrLevel = $module['cefr_level'];
        $sortOrder = $module['sort_order'];
    }
} else {
    // Default values for creating a new module
    $moduleTitle = '';
    $cefrLevel = '';
    $sortOrder = 0;
}
?>
<h3 class="mb-3"><?php echo isset($_GET['edit']) ? 'Edit Module' : 'Create Module'; ?></h3>

<!-- Module Form: For both creating and editing -->
<form method="post" class="mb-3">
  <?php if (isset($module)): ?>
    <input type="hidden" name="module_id" value="<?php echo $module['id']; ?>">
  <?php endif; ?>
  <div class="mb-3">
    <label class="form-label">Module Title (Bangla)</label>
    <input type="text" name="module_title" class="form-control" value="<?php echo htmlspecialchars($moduleTitle); ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">CEFR Level</label>
    <select name="cefr_level" class="form-control">
      <option value="A1" <?php echo $cefrLevel === 'A1' ? 'selected' : ''; ?>>A1</option>
      <option value="A2" <?php echo $cefrLevel === 'A2' ? 'selected' : ''; ?>>A2</option>
      <option value="B1" <?php echo $cefrLevel === 'B1' ? 'selected' : ''; ?>>B1</option>
      <option value="B2" <?php echo $cefrLevel === 'B2' ? 'selected' : ''; ?>>B2</option>
      <option value="C1" <?php echo $cefrLevel === 'C1' ? 'selected' : ''; ?>>C1</option>
      <option value="C2" <?php echo $cefrLevel === 'C2' ? 'selected' : ''; ?>>C2</option>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Sort Order</label>
    <input type="number" name="sort_order" class="form-control" value="<?php echo $sortOrder; ?>" required>
  </div>
  <button class="btn btn-primary"><?php echo isset($module) ? 'Save Module' : 'Create Module'; ?></button>
</form>

<!-- Module List -->
<table class="table table-striped">
  <thead>
    <tr><th>ID</th><th>Title</th><th>CEFR Level</th><th>Sort Order</th><th>Actions</th></tr>
  </thead>
  <tbody>
    <?php foreach ($modules as $module): ?>
      <tr>
        <td><?php echo $module['id']; ?></td>
        <td><?php echo htmlspecialchars($module['module_title_bn']); ?></td>
        <td><?php echo $module['cefr_level']; ?></td>
        <td><?php echo $module['sort_order']; ?></td>
        <td>
          <a class="btn btn-sm btn-outline-info" href="/admin/modules.php?edit=<?php echo $module['id']; ?>">Edit</a>
          <a class="btn btn-sm btn-outline-danger" href="/admin/modules.php?delete=<?php echo $module['id']; ?>">Delete</a>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php include __DIR__ . '/includes/footer.php'; ?>
