<?php
require_once __DIR__ . '/../core/functions.php';
require_once __DIR__ . '/includes/auth_check.php';
include __DIR__ . '/includes/header.php';
$pdo = getDB();

// Fetch all modules to allow lesson assignment
$modules = $pdo->query("SELECT id, module_title_bn FROM modules ORDER BY sort_order")->fetchAll();

// Handle form submissions for both creating and updating lessons
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $lessonTitle = sanitize($_POST['lesson_title'] ?? '');
  $moduleId = (int)($_POST['module_id'] ?? 0);
  $sortOrder = (int)($_POST['sort_order'] ?? 0);

  if (!$lessonTitle || $moduleId <= 0) {
    echo '<div class="alert alert-danger">Invalid input.</div>';
  } else {
    if (!empty($_POST['lesson_id'])) {
      // Update existing lesson
      $lessonId = (int)$_POST['lesson_id'];
      $stmt = $pdo->prepare("UPDATE lessons SET lesson_title_bn = ?, module_id = ?, sort_order = ? WHERE id = ?");
      $stmt->execute([$lessonTitle, $moduleId, $sortOrder, $lessonId]);
      echo '<div class="alert alert-success">Lesson updated.</div>';
    } else {
      // Create new lesson
      $stmt = $pdo->prepare("INSERT INTO lessons (lesson_title_bn, module_id, sort_order) VALUES (?, ?, ?)");
      $stmt->execute([$lessonTitle, $moduleId, $sortOrder]);
      echo '<div class="alert alert-success">Lesson created.</div>';
    }
  }
}

// Handle lesson deletion
if (isset($_GET['delete'])) {
  $lessonId = (int)$_GET['delete'];
  $stmt = $pdo->prepare("DELETE FROM lessons WHERE id = ?");
  $stmt->execute([$lessonId]);
  echo '<div class="alert alert-danger">Lesson deleted.</div>';
}

// Fetch all lessons with associated modules
$lessons = $pdo->query("SELECT l.id, l.lesson_title_bn, l.sort_order, m.module_title_bn FROM lessons l JOIN modules m ON l.module_id = m.id ORDER BY l.sort_order, l.id")->fetchAll();

// If editing a lesson, load the current data
if (isset($_GET['edit'])) {
    $lessonId = (int)$_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM lessons WHERE id = ? LIMIT 1");
    $stmt->execute([$lessonId]);
    $lesson = $stmt->fetch();
    if (!$lesson) {
        echo '<div class="alert alert-danger">Lesson not found.</div>';
    } else {
        $lessonTitle = $lesson['lesson_title_bn'];
        $moduleId = $lesson['module_id'];
        $sortOrder = $lesson['sort_order'];
    }
} else {
    // Default values for creating a new lesson
    $lessonTitle = '';
    $moduleId = 0;
    $sortOrder = 0;
}
?>
<h3 class="mb-3"><?php echo isset($_GET['edit']) ? 'Edit Lesson' : 'Create Lesson'; ?></h3>

<!-- Lesson Form: For both creating and editing -->
<form method="post" class="mb-3">
  <?php if (isset($lesson)): ?>
    <input type="hidden" name="lesson_id" value="<?php echo $lesson['id']; ?>">
  <?php endif; ?>
  <div class="mb-3">
    <label class="form-label">Lesson Title (Bangla)</label>
    <input type="text" name="lesson_title" class="form-control" value="<?php echo htmlspecialchars($lessonTitle); ?>" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Module</label>
    <select name="module_id" class="form-control" required>
      <?php foreach ($modules as $module): ?>
        <option value="<?php echo $module['id']; ?>" <?php echo $module['id'] === $moduleId ? 'selected' : ''; ?>>
          <?php echo htmlspecialchars($module['module_title_bn']); ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">Sort Order</label>
    <input type="number" name="sort_order" class="form-control" value="<?php echo $sortOrder; ?>" required>
  </div>
  <button class="btn btn-primary"><?php echo isset($lesson) ? 'Save Lesson' : 'Create Lesson'; ?></button>
</form>

<!-- Lesson List -->
<table class="table table-striped">
  <thead>
    <tr><th>ID</th><th>Lesson Title</th><th>Module</th><th>Sort Order</th><th>Actions</th></tr>
  </thead>
  <tbody>
    <?php foreach ($lessons as $lesson): ?>
      <tr>
        <td><?php echo $lesson['id']; ?></td>
        <td><?php echo htmlspecialchars($lesson['lesson_title_bn']); ?></td>
        <td><?php echo htmlspecialchars($lesson['module_title_bn']); ?></td>
        <td><?php echo $lesson['sort_order']; ?></td>
        <td>
          <a class="btn btn-sm btn-outline-info" href="/admin/lessons.php?edit=<?php echo $lesson['id']; ?>">Edit</a>
          <a class="btn btn-sm btn-outline-danger" href="/admin/lessons.php?delete=<?php echo $lesson['id']; ?>">Delete</a>
        </td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php include __DIR__ . '/includes/footer.php'; ?>
