<?php
require_once __DIR__ . '/../core/functions.php';
require_once __DIR__ . '/includes/auth_check.php';
include __DIR__ . '/includes/header.php';
$pdo = getDB();

$stats = [
  'users' => (int)$pdo->query("SELECT COUNT(*) FROM users")->fetchColumn(),
  'pending_payouts' => (int)$pdo->query("SELECT COUNT(*) FROM payout_requests WHERE status='pending'")->fetchColumn(),
  'points_redeemed' => (int)$pdo->query("SELECT COALESCE(SUM(points_used),0) FROM payout_requests WHERE status='completed'")->fetchColumn(),
];
?>
<h3 class="mb-4">Dashboard</h3>
<div class="row g-3">
  <div class="col-md-4"><div class="card"><div class="card-body"><h5>Users</h5><p class="display-6"><?php echo $stats['users']; ?></p></div></div></div>
  <div class="col-md-4"><div class="card"><div class="card-body"><h5>Pending Payouts</h5><p class="display-6"><?php echo $stats['pending_payouts']; ?></p></div></div></div>
  <div class="col-md-4"><div class="card"><div class="card-body"><h5>Total Points Redeemed</h5><p class="display-6"><?php echo $stats['points_redeemed']; ?></p></div></div></div>
</div>

<div class="mt-4 d-flex gap-2">
  <a class="btn btn-outline-primary" href="/admin/users.php">Users</a>
  <a class="btn btn-outline-primary" href="/admin/payouts.php">Payouts</a>
  <a class="btn btn-outline-primary" href="/admin/notifications.php">Notifications</a>
  <a class="btn btn-outline-primary" href="/admin/settings.php">Settings</a>
</div>
<?php include __DIR__ . '/includes/footer.php'; ?>
