<?php
require_once __DIR__ . '/../app/lib/auth.php';
require_once __DIR__ . '/../app/lib/helpers.php';

$token = isset($_GET['token']) ? $_GET['token'] : '';
$validRow = null;
if ($token) {
  $stmt = db()->prepare('SELECT pr.id, pr.user_id FROM password_resets pr WHERE pr.token = ? AND pr.expires_at > NOW() AND pr.used_at IS NULL');
  $stmt->execute(array($token));
  $validRow = $stmt->fetch();
}

$msg = null;
if ($validRow && is_post()) {
  csrf_check();
  $p1 = isset($_POST['password']) ? $_POST['password'] : '';
  $p2 = isset($_POST['password_confirmation']) ? $_POST['password_confirmation'] : '';
  if ($p1 === $p2) {
    $hash = password_hash_strong($p1);
    $stmt = db()->prepare('UPDATE users SET password = ? WHERE id = ?');
    $stmt->execute(array($hash, $validRow['user_id']));
    $stmt = db()->prepare('UPDATE password_resets SET used_at = NOW() WHERE id = ?');
    $stmt->execute(array($validRow['id']));
    $msg = "Password updated. You can now login.";
  } else {
    $msg = "Passwords do not match.";
  }
}
?>
<?php include VIEW_ROOT . 'layout_blank_header.php'; ?>
<div class="row justify-content-center">
  <div class="col-md-4">
    <div class="card shadow-sm">
      <div class="card-header">Reset Password</div>
      <div class="card-body">
        <?php if ($msg): ?><div class="alert alert-info"><?= e($msg) ?></div><?php endif; ?>
        <?php if ($validRow): ?>
        <form method="post">
          <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
          <div class="mb-3">
            <label>New Password</label>
            <input class="form-control" type="password" name="password" required>
          </div>
          <div class="mb-3">
            <label>Confirm Password</label>
            <input class="form-control" type="password" name="password_confirmation" required>
          </div>
          <button class="btn btn-primary w-100">Reset</button>
        </form>
        <?php else: ?>
          <div class="alert alert-danger">Invalid or expired token.</div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<?php include VIEW_ROOT . 'layout_blank_footer.php'; ?>
