<?php
require_once __DIR__ . '/../app/lib/auth.php';
require_once __DIR__ . '/../app/lib/helpers.php';
require_admin();

$rows = db()->query('SELECT n.*, a.appName FROM notifications n JOIN apps a ON a.id = n.appId ORDER BY n.id DESC')->fetchAll();
?>
<?php include VIEW_ROOT . 'layout_header.php'; ?>
<h3>Notifications</h3>
<div class="card">
  <div class="table-responsive">
    <table class="table table-striped mb-0">
      <thead><tr><th>ID</th><th>App</th><th>Message</th><th>Schedule</th><th>Status</th><th>Sent</th></tr></thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td><?= (int)$r['id'] ?></td>
            <td><?= e($r['appName']) ?></td>
            <td><?= e($r['message']) ?></td>
            <td><?= e($r['scheduleTime']) ?></td>
            <td><?= e($r['status']) ?></td>
            <td><?= (int)$r['sentCount'] ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include VIEW_ROOT . 'layout_footer.php'; ?>
