<?php
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/helpers.php';

function csrf_token() {
    if (empty($_SESSION['csrf'])) {
        $_SESSION['csrf'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf'];
}

function csrf_check() {
    $token = isset($_POST['csrf']) ? $_POST['csrf'] : (isset($_SERVER['HTTP_X_CSRF_TOKEN']) ? $_SERVER['HTTP_X_CSRF_TOKEN'] : '');
    if (empty($_SESSION['csrf']) || !hash_equals($_SESSION['csrf'], $token)) {
        http_response_code(419);
        exit('CSRF validation failed');
    }
}

function password_hash_strong($password) {
    return password_hash($password, PASSWORD_BCRYPT);
}

function current_user() {
    if (!empty($_SESSION['user_id'])) {
        $stmt = db()->prepare('SELECT id, email, name, is_admin FROM users WHERE id = ?');
        $stmt->execute(array($_SESSION['user_id']));
        return $stmt->fetch();
    }
    return null;
}

function require_admin() {
    $user = current_user();
    if (!$user) redirect('/login.php');
}

function login($email, $password) {
    $stmt = db()->prepare('SELECT * FROM users WHERE email = ? LIMIT 1');
    $stmt->execute(array($email));
    $user = $stmt->fetch();
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        return true;
    }
    return false;
}

function logout() { session_destroy(); }

function create_audit($user_id, $action, $meta = array()) {
    $stmt = db()->prepare('INSERT INTO audit_logs (user_id, action, meta, created_at) VALUES (?, ?, ?, NOW())');
    $stmt->execute(array($user_id, $action, json_encode($meta)));
}
