<?php
require_once __DIR__ . '/../app/lib/auth.php';
require_once __DIR__ . '/../app/lib/helpers.php';

$token = $_GET['token'] ?? '';
$valid = false;
if ($token) {
  $stmt = db()->prepare('SELECT pr.id, pr.user_id FROM password_resets pr WHERE pr.token = ? AND pr.expires_at > NOW() AND pr.used_at IS NULL');
  $stmt->execute([$token]);
  $row = $stmt->fetch();
  if ($row) $valid = true;
}

$msg = null;
if ($valid && is_post()) {
  csrf_check();
  if (($_POST['password'] ?? '') === ($_POST['password_confirmation'] ?? '')) {
    $hash = password_hash_strong($_POST['password']);
    $stmt = db()->prepare('UPDATE users SET password = ? WHERE id = ?');
    $stmt->execute([$hash, $row['user_id']]);
    $stmt = db()->prepare('UPDATE password_resets SET used_at = NOW() WHERE id = ?');
    $stmt->execute([$row['id']]);
    $msg = "Password updated. You can now login.";
  } else {
    $msg = "Passwords do not match.";
  }
}
?>
<?php include VIEW_ROOT . 'layout_header.php'; ?>
<div class="row justify-content-center">
  <div class="col-md-4">
    <div class="card">
      <div class="card-header">Reset Password</div>
      <div class="card-body">
        <?php if ($msg): ?><div class="alert alert-info"><?= e($msg) ?></div><?php endif; ?>
        <?php if ($valid): ?>
        <form method="post">
          <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
          <div class="mb-3">
            <label>New Password</label>
            <input class="form-control" type="password" name="password" required>
          </div>
          <div class="mb-3">
            <label>Confirm Password</label>
            <input class="form-control" type="password" name="password_confirmation" required>
          </div>
          <button class="btn btn-primary w-100">Reset</button>
        </form>
        <?php else: ?>
          <div class="alert alert-danger">Invalid or expired token.</div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<?php include VIEW_ROOT . 'layout_footer.php'; ?>
