<?php
require_once __DIR__ . '/../app/lib/auth.php';
require_once __DIR__ . '/../app/lib/helpers.php';
require_admin();

if (is_post()) {
    csrf_check();
    $stmt = db()->prepare('INSERT INTO apps (appName, packageName, versionNumber, status, adNetwork, iconUrl, tags, api_key, remarks, created_at, updated_at) VALUES (?,?,?,?,?,?,?,?,?,NOW(),NOW())');
    $apiKey = bin2hex(random_bytes(16));
    $stmt->execute([$_POST['appName'], $_POST['packageName'], $_POST['versionNumber'], $_POST['status'], $_POST['adNetwork'], $_POST['iconUrl'], $_POST['tags'], $apiKey, $_POST['remarks']]);
    create_audit($_SESSION['user_id'], 'app_create', ['package' => $_POST['packageName']]);
    redirect('/apps.php');
}

$apps = db()->query('SELECT * FROM apps ORDER BY created_at DESC')->fetchAll();
?>
<?php include VIEW_ROOT . 'layout_header.php'; ?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>Apps</h3>
  <button class="btn btn-primary" data-bs-toggle="collapse" data-bs-target="#addForm">Add App</button>
</div>

<div id="addForm" class="collapse mb-4">
  <div class="card">
    <div class="card-body">
      <form method="post">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <div class="row g-2">
          <div class="col-md-3"><input class="form-control" name="appName" placeholder="App Name" required></div>
          <div class="col-md-3"><input class="form-control" name="packageName" placeholder="Package Name" required></div>
          <div class="col-md-2"><input class="form-control" name="versionNumber" placeholder="Version" required></div>
          <div class="col-md-2">
            <select class="form-select" name="status">
              <option>Active</option><option>Inactive</option><option>Suspended</option>
            </select>
          </div>
          <div class="col-md-2">
            <select class="form-select" name="adNetwork">
              <option>AdMob</option><option>AudienceNetwork</option><option>Disabled</option>
            </select>
          </div>
          <div class="col-md-3"><input class="form-control" name="iconUrl" placeholder="Icon URL"></div>
          <div class="col-md-3"><input class="form-control" name="tags" placeholder="Tags (comma separated)"></div>
          <div class="col-md-6"><input class="form-control" name="remarks" placeholder="Remarks"></div>
        </div>
        <div class="mt-2"><button class="btn btn-success">Save</button></div>
      </form>
    </div>
  </div>
</div>

<div class="card">
  <div class="table-responsive">
    <table class="table table-striped table-hover mb-0">
      <thead class="table-light">
        <tr>
          <th>Icon</th>
          <th>Name</th>
          <th>Package</th>
          <th>Version</th>
          <th>Status</th>
          <th>Ad Network</th>
          <th>API Key</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($apps as $a): ?>
        <tr>
          <td><?php if ($a['iconUrl']): ?><img src="<?= e($a['iconUrl']) ?>" style="width:32px;height:32px;border-radius:6px;"><?php endif; ?></td>
          <td><?= e($a['appName']) ?></td>
          <td><code><?= e($a['packageName']) ?></code></td>
          <td><?= e($a['versionNumber']) ?></td>
          <td><?= e($a['status']) ?></td>
          <td><?= e($a['adNetwork']) ?></td>
          <td><small><?= e($a['api_key']) ?></small></td>
          <td>
            <a class="btn btn-sm btn-outline-primary" href="/app_edit.php?id=<?= (int)$a['id'] ?>">Manage</a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include VIEW_ROOT . 'layout_footer.php'; ?>
