<?php
require_once __DIR__ . '/../app/lib/auth.php';
require_once __DIR__ . '/../app/lib/helpers.php';
require_admin();

$id = (int)($_GET['id'] ?? 0);
$stmt = db()->prepare('SELECT * FROM apps WHERE id = ?');
$stmt->execute([$id]);
$app = $stmt->fetch();
if (!$app) { exit('App not found'); }

// Handle updates
if (is_post()) {
    csrf_check();
    if (isset($_POST['updateApp'])) {
        $stmt = db()->prepare('UPDATE apps SET appName=?, packageName=?, versionNumber=?, status=?, adNetwork=?, iconUrl=?, tags=?, remarks=?, updated_at=NOW() WHERE id=?');
        $stmt->execute([$_POST['appName'], $_POST['packageName'], $_POST['versionNumber'], $_POST['status'], $_POST['adNetwork'], $_POST['iconUrl'], $_POST['tags'], $_POST['remarks'], $id]);
        create_audit($_SESSION['user_id'], 'app_update', ['id'=>$id]);
        redirect('/app_edit.php?id=' . $id);
    }
    if (isset($_POST['forceUpdate'])) {
        $minVersion = $_POST['minVersion'];
        $stmt = db()->prepare('UPDATE apps SET force_min_version=? WHERE id=?');
        $stmt->execute([$minVersion, $id]);
        create_audit($_SESSION['user_id'], 'force_update_set', ['id'=>$id, 'min'=>$minVersion]);
        redirect('/app_edit.php?id=' . $id);
    }
    if (isset($_POST['newVersion'])) {
        $stmt = db()->prepare('INSERT INTO version_history (appId, versionNumber, changelog, releaseDate) VALUES (?,?,?,NOW())');
        $stmt->execute([$id, $_POST['versionNumber'], $_POST['changelog']]);
        create_audit($_SESSION['user_id'], 'version_added', ['id'=>$id, 'version'=>$_POST['versionNumber']]);
        redirect('/app_edit.php?id=' . $id);
    }
    if (isset($_POST['sendNotification'])) {
        $stmt = db()->prepare('INSERT INTO notifications (appId, message, scheduleTime, status, sentCount, created_at) VALUES (?,?,?,?,0,NOW())');
        $stmt->execute([$id, $_POST['message'], $_POST['scheduleTime'] ?: null, 'scheduled']);
        create_audit($_SESSION['user_id'], 'notification_scheduled', ['id'=>$id]);
        redirect('/app_edit.php?id=' . $id);
    }
}

$versions = db()->prepare('SELECT * FROM version_history WHERE appId = ? ORDER BY releaseDate DESC');
$versions->execute([$id]);
$versions = $versions->fetchAll();

$adUnits = db()->prepare('SELECT * FROM ad_units WHERE appId = ? ORDER BY id DESC');
$adUnits->execute([$id]);
$adUnits = $adUnits->fetchAll();

$notifs = db()->prepare('SELECT * FROM notifications WHERE appId = ? ORDER BY id DESC');
$notifs->execute([$id]);
$notifs = $notifs->fetchAll();
?>
<?php include VIEW_ROOT . 'layout_header.php'; ?>
<h3><?= e($app['appName']) ?> <small class="text-muted">(<?= e($app['packageName']) ?>)</small></h3>

<div class="row g-3">
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">Overview</div>
      <div class="card-body">
        <form method="post">
          <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
          <input type="hidden" name="updateApp" value="1">
          <div class="mb-2"><label>Name</label><input class="form-control" name="appName" value="<?= e($app['appName']) ?>"></div>
          <div class="mb-2"><label>Package</label><input class="form-control" name="packageName" value="<?= e($app['packageName']) ?>"></div>
          <div class="mb-2"><label>Version</label><input class="form-control" name="versionNumber" value="<?= e($app['versionNumber']) ?>"></div>
          <div class="mb-2">
            <label>Status</label>
            <select class="form-select" name="status">
              <?php foreach (['Active','Inactive','Suspended'] as $s): ?>
                <option <?= $app['status']===$s?'selected':'' ?>><?= $s ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-2">
            <label>Ad Network</label>
            <select class="form-select" name="adNetwork">
              <?php foreach (['AdMob','AudienceNetwork','Disabled'] as $n): ?>
                <option <?= $app['adNetwork']===$n?'selected':'' ?>><?= $n ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-2"><label>Icon URL</label><input class="form-control" name="iconUrl" value="<?= e($app['iconUrl']) ?>"></div>
          <div class="mb-2"><label>Tags</label><input class="form-control" name="tags" value="<?= e($app['tags']) ?>"></div>
          <div class="mb-2"><label>Remarks</label><textarea class="form-control" name="remarks"><?= e($app['remarks']) ?></textarea></div>
          <button class="btn btn-primary">Save</button>
        </form>
      </div>
    </div>
    <div class="card mt-3">
      <div class="card-header">Force Update</div>
      <div class="card-body">
        <form method="post">
          <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
          <input type="hidden" name="forceUpdate" value="1">
          <label>Minimum Required Version</label>
          <input class="form-control mb-2" name="minVersion" value="<?= e($app['force_min_version']) ?>" placeholder="e.g., 3.2.0">
          <button class="btn btn-warning">Set Force Update</button>
        </form>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">Version History</div>
      <div class="card-body">
        <form method="post" class="mb-3">
          <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
          <input type="hidden" name="newVersion" value="1">
          <div class="row g-2">
            <div class="col-md-4"><input class="form-control" name="versionNumber" placeholder="Version" required></div>
            <div class="col-md-8"><input class="form-control" name="changelog" placeholder="Changelog"></div>
          </div>
          <button class="btn btn-success btn-sm mt-2">Add Version</button>
        </form>
        <ul class="list-group">
          <?php foreach ($versions as $v): ?>
            <li class="list-group-item d-flex justify-content-between align-items-center">
              <div><strong><?= e($v['versionNumber']) ?></strong><br><small><?= e($v['changelog']) ?></small></div>
              <span class="badge bg-secondary"><?= e($v['releaseDate']) ?></span>
            </li>
          <?php endforeach; ?>
        </ul>
      </div>
    </div>

    <div class="card mt-3">
      <div class="card-header">Custom Notifications</div>
      <div class="card-body">
        <form method="post">
          <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
          <input type="hidden" name="sendNotification" value="1">
          <div class="mb-2"><textarea class="form-control" name="message" placeholder="Notification message" required></textarea></div>
          <div class="mb-2"><input class="form-control" type="datetime-local" name="scheduleTime"></div>
          <button class="btn btn-primary btn-sm">Schedule</button>
        </form>
        <hr>
        <ul class="list-group">
          <?php foreach ($notifs as $n): ?>
            <li class="list-group-item">
              <div><strong><?= e($n['message']) ?></strong></div>
              <small>Status: <?= e($n['status']) ?> | Schedule: <?= e($n['scheduleTime']) ?> | Sent: <?= (int)$n['sentCount'] ?></small>
            </li>
          <?php endforeach; ?>
        </ul>
      </div>
    </div>

    <div class="card mt-3">
      <div class="card-header">Ad Units</div>
      <div class="card-body">
        <ul class="list-group">
          <?php foreach ($adUnits as $u): ?>
            <li class="list-group-item d-flex justify-content-between">
              <div>
                <div><strong><?= e($u['adType']) ?></strong> (<?= e($u['network']) ?>)</div>
                <code><?= e($u['adUnitId']) ?></code> <?= $u['isTestMode'] ? '<span class="badge bg-warning">Test</span>' : '' ?>
              </div>
            </li>
          <?php endforeach; ?>
        </ul>
        <a class="btn btn-outline-secondary btn-sm mt-2" href="/adunits.php?appId=<?= (int)$app['id'] ?>">Manage Ad Units</a>
      </div>
    </div>
  </div>
</div>
<?php include VIEW_ROOT . 'layout_footer.php'; ?>
