<?php
require_once __DIR__ . '/../../app/lib/helpers.php';

$headers = getallheaders();
$apiKey = $headers['X-API-KEY'] ?? $headers['x-api-key'] ?? null;

function require_api_key($apiKey) {
    if (!$apiKey) json_response(['error'=>'Missing API key'], 401);
    $stmt = db()->prepare('SELECT * FROM apps WHERE api_key = ?');
    $stmt->execute([$apiKey]);
    $app = $stmt->fetch();
    if (!$app || $app['status'] !== 'Active') json_response(['error'=>'Invalid API key or app inactive'], 403);
    return $app;
}

switch ($resource) {
    case 'apps':
        if ($method === 'GET') {
            $stmt = db()->query('SELECT id, appName, packageName, versionNumber, status, adNetwork, iconUrl, tags, force_min_version FROM apps ORDER BY id DESC');
            json_response($stmt->fetchAll());
        }
        if ($method === 'POST') {
            $data = json_input();
            $stmt = db()->prepare('INSERT INTO apps (appName, packageName, versionNumber, status, adNetwork, iconUrl, tags, api_key, created_at, updated_at) VALUES (?,?,?,?,?,?,?,?,NOW(),NOW())');
            $stmt->execute([$data['appName'],$data['packageName'],$data['versionNumber'],$data['status'],$data['adNetwork'],$data['iconUrl'],$data['tags'], bin2hex(random_bytes(16))]);
            json_response(['ok'=>true], 201);
        }
        if ($id && $method === 'PUT') {
            $data = json_input();
            $stmt = db()->prepare('UPDATE apps SET appName=?, packageName=?, versionNumber=?, status=?, adNetwork=?, iconUrl=?, tags=?, updated_at=NOW() WHERE id=?');
            $stmt->execute([$data['appName'],$data['packageName'],$data['versionNumber'],$data['status'],$data['adNetwork'],$data['iconUrl'],$data['tags'],$id]);
            json_response(['ok'=>true]);
        }
        if ($id && $method === 'DELETE') {
            $stmt = db()->prepare('DELETE FROM apps WHERE id=?');
            $stmt->execute([$id]);
            json_response(['ok'=>true]);
        }
        json_response(['error'=>'Method Not Allowed'], 405);
        break;

    case 'config':
        // Apps call this with X-API-KEY to fetch live config
        // GET /api/config
        $app = require_api_key($apiKey);
        // load ad units for this app too
        $stmt = db()->prepare('SELECT adUnitId, adType, network, isTestMode FROM ad_units WHERE appId = ?');
        $stmt->execute([$app['id']]);
        $units = $stmt->fetchAll();

        // get latest scheduled notification not yet sent (simplified)
        $notif = db()->prepare('SELECT id, message FROM notifications WHERE appId = ? AND (scheduleTime IS NULL OR scheduleTime <= NOW()) AND status IN ("scheduled","pending") ORDER BY id DESC LIMIT 1');
        $notif->execute([$app['id']]);
        $notif = $notif->fetch();

        json_response([
            'packageName' => $app['packageName'],
            'currentVersion' => $app['versionNumber'],
            'forceMinVersion' => $app['force_min_version'],
            'adNetwork' => $app['adNetwork'],
            'adUnits' => $units,
            'notification' => $notif ?: null,
        ]);
        break;

    case 'notifications':
        // Apps can confirm delivery
        // POST /api/notifications/{id}/ack
        if ($id && $method === 'POST' && isset($segments[3]) && $segments[3] === 'ack') {
            $app = require_api_key($apiKey);
            $stmt = db()->prepare('UPDATE notifications SET status = "sent", sentCount = sentCount + 1 WHERE id = ? AND appId = ?');
            $stmt->execute([$id, $app['id']]);
            json_response(['ok'=>true]);
        }
        json_response(['error'=>'Not Found'], 404);
        break;

    default:
        json_response(['error'=>'Not Found'], 404);
}
