<?php
require_once __DIR__ . '/../../app/lib/helpers.php';
require_once __DIR__ . '/../../app/lib/rate_limit.php';
require_once __DIR__ . '/../../app/config/db.php';

$path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$method = $_SERVER['REQUEST_METHOD'];
$segments = explode('/', trim($path, '/'));

// Rate limit by IP & path
$rlKey = ($_SERVER['REMOTE_ADDR'] ?? 'ip') . '|' . $path;
if (!rate_limit_ok($rlKey, 120, 60)) {
    json_response(['error' => 'Too Many Requests'], 429);
}

// Determine route
// /api/apps, /api/apps/{id}, /api/config/{package}, /api/notifications (send)
if (count($segments) < 2 || $segments[0] !== 'api') {
    json_response(['error' => 'Not Found'], 404);
}

$resource = $segments[1];
$id = $segments[2] ?? null;

require __DIR__ . '/routes.php';
