-- MySQL schema
CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  email VARCHAR(191) UNIQUE NOT NULL,
  name VARCHAR(191) NULL,
  password VARCHAR(255) NOT NULL,
  is_admin TINYINT(1) DEFAULT 1,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS apps (
  id INT AUTO_INCREMENT PRIMARY KEY,
  appName VARCHAR(191) NOT NULL,
  packageName VARCHAR(191) UNIQUE NOT NULL,
  versionNumber VARCHAR(50) NOT NULL,
  status ENUM('Active','Inactive','Suspended') DEFAULT 'Active',
  adNetwork ENUM('AdMob','AudienceNetwork','Disabled') DEFAULT 'AdMob',
  iconUrl VARCHAR(255) NULL,
  tags VARCHAR(255) NULL,
  api_key VARCHAR(64) NOT NULL,
  force_min_version VARCHAR(50) NULL,
  remarks TEXT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS ad_units (
  id INT AUTO_INCREMENT PRIMARY KEY,
  appId INT NOT NULL,
  adUnitId VARCHAR(191) NOT NULL,
  adType ENUM('banner','interstitial','rewarded','native') NOT NULL,
  network ENUM('AdMob','AudienceNetwork') NOT NULL,
  isTestMode TINYINT(1) DEFAULT 0,
  FOREIGN KEY (appId) REFERENCES apps(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS notifications (
  id INT AUTO_INCREMENT PRIMARY KEY,
  appId INT NOT NULL,
  message TEXT NOT NULL,
  scheduleTime DATETIME NULL,
  status ENUM('scheduled','pending','sent','failed') DEFAULT 'scheduled',
  sentCount INT DEFAULT 0,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (appId) REFERENCES apps(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS version_history (
  id INT AUTO_INCREMENT PRIMARY KEY,
  appId INT NOT NULL,
  versionNumber VARCHAR(50) NOT NULL,
  changelog TEXT NULL,
  releaseDate DATETIME NOT NULL,
  FOREIGN KEY (appId) REFERENCES apps(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS analytics (
  id INT AUTO_INCREMENT PRIMARY KEY,
  appId INT NOT NULL,
  metricType VARCHAR(100) NOT NULL,
  value DECIMAL(12,4) NOT NULL DEFAULT 0,
  date DATE NOT NULL,
  FOREIGN KEY (appId) REFERENCES apps(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS audit_logs (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NULL,
  action VARCHAR(191) NOT NULL,
  meta JSON NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS password_resets (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  token VARCHAR(128) NOT NULL,
  expires_at DATETIME NOT NULL,
  used_at DATETIME NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS rate_limits (
  rate_key VARCHAR(191) PRIMARY KEY,
  count INT NOT NULL DEFAULT 0,
  window_end DATETIME NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Seed admin
INSERT INTO users (email, name, password, is_admin) VALUES
('admin@example.com', 'Admin', '$2y$10$1l8c1iNfC3l2H0w6f9ksE.j8b8qz5Hq2x7n1mVt6n5r7p5h2o1V9G', 1)
ON DUPLICATE KEY UPDATE email=email;

-- The seeded password hash corresponds to: Admin@12345
