<?php
require_once __DIR__ . '/../config/db.php';

function rate_limit_ok($key, $max, $window_seconds) {
    $stmt = db()->prepare('SELECT count FROM rate_limits WHERE rate_key = ?');
    $stmt->execute([$key]);
    $row = $stmt->fetch();

    if (!$row) {
        $stmt = db()->prepare('INSERT INTO rate_limits (rate_key, count, window_end) VALUES (?, 1, DATE_ADD(NOW(), INTERVAL ? SECOND))');
        $stmt->execute([$key, $window_seconds]);
        return true;
    }

    $stmt2 = db()->prepare('SELECT count, window_end FROM rate_limits WHERE rate_key = ?');
    $stmt2->execute([$key]);
    $row = $stmt2->fetch();

    if (strtotime($row['window_end']) < time()) {
        $stmt = db()->prepare('UPDATE rate_limits SET count = 1, window_end = DATE_ADD(NOW(), INTERVAL ? SECOND) WHERE rate_key = ?');
        $stmt->execute([$window_seconds, $key]);
        return true;
    } else {
        if ($row['count'] < $max) {
            $stmt = db()->prepare('UPDATE rate_limits SET count = count + 1 WHERE rate_key = ?');
            $stmt->execute([$key]);
            return true;
        }
    }
    return false;
}
