<?php
require_once __DIR__ . '/../config/config.php';

function redirect($path) {
    header('Location: ' . $path);
    exit;
}

function is_post() { return $_SERVER['REQUEST_METHOD'] === 'POST'; }
function is_put() { return $_SERVER['REQUEST_METHOD'] === 'PUT'; }
function is_delete() { return $_SERVER['REQUEST_METHOD'] === 'DELETE'; }

function input($key, $default=null) { return $_POST[$key] ?? $_GET[$key] ?? $default; }
function json_input() {
    $raw = file_get_contents('php://input');
    $data = json_decode($raw, true);
    return is_array($data) ? $data : [];
}

function json_response($data, $code=200) {
    http_response_code($code);
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

function e($str) { return htmlspecialchars((string)$str, ENT_QUOTES, 'UTF-8'); }
