<?php
// Simple .env loader
function env($key, $default = null) {
    static $env = null;
    if ($env === null) {
        $env = [];
        $path = __DIR__ . '/../../.env';
        if (!file_exists($path)) {
            $path = __DIR__ . '/../../.env.example';
        }
        foreach (file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) as $line) {
            if (str_starts_with(trim($line), '#')) continue;
            if (!str_contains($line, '=')) continue;
            [$k, $v] = array_map('trim', explode('=', $line, 2));
            $v = trim($v, ''"');
            $env[$k] = $v;
        }
    }
    return $env[$key] ?? $default;
}

date_default_timezone_set('UTC');
session_name(env('SESSION_NAME', 'app_panel_session'));
session_start();

const APP_ROOT = __DIR__ . '/../../';
const VIEW_ROOT = __DIR__ . '/../views/';
