<?php
require_once __DIR__ . '/../app/lib/auth.php';
require_once __DIR__ . '/../app/lib/helpers.php';
require_once __DIR__ . '/../app/lib/mailer.php';

$msg = null;
if (is_post()) {
    csrf_check();
    $email = isset($_POST['email']) ? $_POST['email'] : '';
    $stmt = db()->prepare('SELECT id FROM users WHERE email = ?');
    $stmt->execute(array($email));
    $user = $stmt->fetch();
    if ($user) {
        $token = bin2hex(random_bytes(32));
        $expiry = (int) env('RESET_TOKEN_EXPIRY_MINUTES', 60);
        $stmt2 = db()->prepare('INSERT INTO password_resets (user_id, token, expires_at) VALUES (?, ?, DATE_ADD(NOW(), INTERVAL ? MINUTE))');
        $stmt2->execute(array($user['id'], $token, $expiry));
        $link = rtrim(env('APP_URL','http://localhost'), '/') . '/reset_password.php?token=' . urlencode($token);
        send_mail($email, 'Password Reset', 'Click to reset your password: <a href="' . $link . '">' . $link . '</a>');
    }
    $msg = "If the email exists, a reset link has been sent.";
}
?>
<?php include VIEW_ROOT . 'layout_blank_header.php'; ?>
<div class="row justify-content-center">
  <div class="col-md-4">
    <div class="card shadow-sm">
      <div class="card-header">Request Password Reset</div>
      <div class="card-body">
        <?php if ($msg): ?><div class="alert alert-info"><?= e($msg) ?></div><?php endif; ?>
        <form method="post">
          <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
          <div class="mb-3">
            <label>Email</label>
            <input class="form-control" type="email" name="email" required>
          </div>
          <button class="btn btn-primary w-100">Send Link</button>
        </form>
      </div>
    </div>
  </div>
</div>
<?php include VIEW_ROOT . 'layout_blank_footer.php'; ?>
