<?php
require_once __DIR__ . '/../app/lib/auth.php';
require_once __DIR__ . '/../app/lib/helpers.php';
require_admin();

$logs = db()->query('SELECT l.*, u.email FROM audit_logs l LEFT JOIN users u ON u.id = l.user_id ORDER BY l.id DESC LIMIT 200')->fetchAll();
?>
<?php include VIEW_ROOT . 'layout_header.php'; ?>
<h3>Audit Logs (latest 200)</h3>
<div class="card">
  <div class="table-responsive">
    <table class="table table-striped mb-0">
      <thead><tr><th>ID</th><th>User</th><th>Action</th><th>Meta</th><th>At</th></tr></thead>
      <tbody>
        <?php foreach ($logs as $l): ?>
          <tr>
            <td><?= (int)$l['id'] ?></td>
            <td><?= e($l['email'] ? $l['email'] : 'system') ?></td>
            <td><?= e($l['action']) ?></td>
            <td><code><?= e($l['meta']) ?></code></td>
            <td><?= e($l['created_at']) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include VIEW_ROOT . 'layout_footer.php'; ?>
