<?php
require_once __DIR__ . '/../app/lib/auth.php';
require_once __DIR__ . '/../app/lib/helpers.php';

$error = null;
if (is_post()) {
    csrf_check();
    if (login(isset($_POST['email']) ? $_POST['email'] : '', isset($_POST['password']) ? $_POST['password'] : '')) {
        create_audit($_SESSION['user_id'], 'login', array('ip' => isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : null));
        redirect('/dashboard.php');
    } else {
        $error = "Invalid credentials";
    }
}
?>
<?php include VIEW_ROOT . 'layout_blank_header.php'; ?>
<div class="row justify-content-center">
  <div class="col-md-4">
    <div class="card shadow-sm">
      <div class="card-header">Admin Login</div>
      <div class="card-body">
        <?php if ($error): ?><div class="alert alert-danger"><?= e($error) ?></div><?php endif; ?>
        <form method="post">
          <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
          <div class="mb-3">
            <label>Email</label>
            <input class="form-control" type="email" name="email" required>
          </div>
          <div class="mb-3">
            <label>Password</label>
            <input class="form-control" type="password" name="password" required>
          </div>
          <button class="btn btn-primary w-100">Login</button>
        </form>
        <div class="mt-3 text-center"><a href="/reset_request.php">Forgot password?</a></div>
      </div>
    </div>
  </div>
</div>
<?php include VIEW_ROOT . 'layout_blank_footer.php'; ?>
