<?php
require_once __DIR__ . '/../app/lib/auth.php';
require_once __DIR__ . '/../app/lib/helpers.php';
require_admin();

$apps = db()->query('SELECT COUNT(*) as c FROM apps')->fetch();
$notifications = db()->query('SELECT COUNT(*) as c FROM notifications')->fetch();
$revenue = db()->query('SELECT COALESCE(SUM(value),0) as r FROM analytics WHERE metricType = "revenue"')->fetch();
?>
<?php include VIEW_ROOT . 'layout_header.php'; ?>
<div class="row g-3">
  <div class="col-md-4">
    <div class="card shadow-sm">
      <div class="card-body">
        <h5 class="card-title">Total Apps</h5>
        <p class="display-6"><?= e($apps ? $apps['c'] : 0) ?></p>
      </div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card shadow-sm">
      <div class="card-body">
        <h5 class="card-title">Notifications</h5>
        <p class="display-6"><?= e($notifications ? $notifications['c'] : 0) ?></p>
      </div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card shadow-sm">
      <div class="card-body">
        <h5 class="card-title">Total Revenue</h5>
        <p class="display-6">$<?= e(number_format($revenue ? $revenue['r'] : 0,2)) ?></p>
      </div>
    </div>
  </div>
</div>
<?php include VIEW_ROOT . 'layout_footer.php'; ?>
