<?php
require_once __DIR__ . '/../../app/lib/helpers.php';

$headers = function_exists('getallheaders') ? getallheaders() : array();
$apiKey = isset($headers['X-API-KEY']) ? $headers['X-API-KEY'] : (isset($headers['x-api-key']) ? $headers['x-api-key'] : null);

function require_api_key($apiKey) {
    if (!$apiKey) json_response(array('error'=>'Missing API key'), 401);
    $stmt = db()->prepare('SELECT * FROM apps WHERE api_key = ?');
    $stmt->execute(array($apiKey));
    $app = $stmt->fetch();
    if (!$app || $app['status'] !== 'Active') json_response(array('error'=>'Invalid API key or app inactive'), 403);
    return $app;
}

switch ($resource) {
    case 'apps':
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            $stmt = db()->query('SELECT id, appName, packageName, versionNumber, status, adNetwork, iconUrl, tags, force_min_version FROM apps ORDER BY id DESC');
            json_response($stmt->fetchAll());
        }
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = json_input();
            $stmt = db()->prepare('INSERT INTO apps (appName, packageName, versionNumber, status, adNetwork, iconUrl, tags, api_key, created_at, updated_at) VALUES (?,?,?,?,?,?,?,?,NOW(),NOW())');
            $stmt->execute(array($data['appName'],$data['packageName'],$data['versionNumber'],$data['status'],$data['adNetwork'],$data['iconUrl'],$data['tags'], bin2hex(random_bytes(16))));
            json_response(array('ok'=>true), 201);
        }
        if ($id && $_SERVER['REQUEST_METHOD'] === 'PUT') {
            $data = json_input();
            $stmt = db()->prepare('UPDATE apps SET appName=?, packageName=?, versionNumber=?, status=?, adNetwork=?, iconUrl=?, tags=?, updated_at=NOW() WHERE id=?');
            $stmt->execute(array($data['appName'],$data['packageName'],$data['versionNumber'],$data['status'],$data['adNetwork'],$data['iconUrl'],$data['tags'],$id));
            json_response(array('ok'=>true));
        }
        if ($id && $_SERVER['REQUEST_METHOD'] === 'DELETE') {
            $stmt = db()->prepare('DELETE FROM apps WHERE id=?');
            $stmt->execute(array($id));
            json_response(array('ok'=>true));
        }
        json_response(array('error'=>'Method Not Allowed'), 405);
        break;

    case 'config':
        $app = require_api_key($apiKey);
        $headersAll = function_exists('getallheaders') ? getallheaders() : array();
        $deviceId = isset($headersAll['X-DEVICE-ID']) ? trim($headersAll['X-DEVICE-ID']) : (isset($headersAll['x-device-id']) ? trim($headersAll['x-device-id']) : null);

        $stmt = db()->prepare('SELECT adUnitId, adType, network, isTestMode FROM ad_units WHERE appId = ?');
        $stmt->execute(array($app['id']));
        $units = $stmt->fetchAll();

        if ($deviceId) {
            $sql = 'SELECT n.id, n.message
                    FROM notifications n
                    LEFT JOIN notification_receipts r
                      ON r.notificationId = n.id AND r.deviceId = ?
                    WHERE n.appId = ? AND (n.scheduleTime IS NULL OR n.scheduleTime <= NOW())
                      AND n.status IN ("scheduled","pending")
                      AND r.id IS NULL
                    ORDER BY n.id DESC LIMIT 1';
            $notifStmt = db()->prepare($sql);
            $notifStmt->execute(array($deviceId, $app['id']));
            $notif = $notifStmt->fetch();
        } else {
            $notifStmt = db()->prepare('SELECT id, message FROM notifications
              WHERE appId = ? AND (scheduleTime IS NULL OR scheduleTime <= NOW())
              AND status IN ("scheduled","pending") ORDER BY id DESC LIMIT 1');
            $notifStmt->execute(array($app['id']));
            $notif = $notifStmt->fetch();
        }

        json_response(array(
            'packageName' => $app['packageName'],
            'currentVersion' => $app['versionNumber'],
            'forceMinVersion' => $app['force_min_version'],
            'adNetwork' => $app['adNetwork'],
            'adUnits' => $units,
            'notification' => $notif ? $notif : null,
        ));
        break;

    case 'notifications':
        if ($id && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($segments[3]) && $segments[3] === 'ack') {
            $app = require_api_key($apiKey);
            $headersAll = function_exists('getallheaders') ? getallheaders() : array();
            $deviceId = isset($headersAll['X-DEVICE-ID']) ? trim($headersAll['X-DEVICE-ID']) : (isset($headersAll['x-device-id']) ? trim($headersAll['x-device-id']) : null);
            if (!$deviceId) json_response(array('error' => 'Missing X-DEVICE-ID'), 400);

            $stmt = db()->prepare('INSERT IGNORE INTO notification_receipts (appId, notificationId, deviceId, delivered_at) VALUES (?,?,?,NOW())');
            $stmt->execute(array($app['id'], $id, $deviceId));

            $bump = db()->prepare('UPDATE notifications SET sentCount = sentCount + 1 WHERE id = ?');
            $bump->execute(array($id));

            json_response(array('ok'=>true));
        }
        json_response(array('error'=>'Not Found'), 404);
        break;

    default:
        json_response(array('error'=>'Not Found'), 404);
}
