<?php
require_once __DIR__ . '/../../app/lib/helpers.php';
require_once __DIR__ . '/../../app/lib/rate_limit.php';
require_once __DIR__ . '/../../app/config/db.php';

$path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$method = $_SERVER['REQUEST_METHOD'];
$segments = explode('/', trim($path, '/'));

$rlKey = (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 'ip') . '|' . $path;
if (!rate_limit_ok($rlKey, 120, 60)) {
    json_response(array('error' => 'Too Many Requests'), 429);
}

if (count($segments) < 2 || $segments[0] !== 'api') {
    json_response(array('error' => 'Not Found'), 404);
}

$resource = $segments[1];
$id = isset($segments[2]) ? $segments[2] : null;

require __DIR__ . '/routes.php';
