<?php
require_once __DIR__ . '/../app/lib/auth.php';
require_once __DIR__ . '/../app/lib/helpers.php';
require_admin();

$appId = (int)($_GET['appId'] ?? 0);
if (!$appId) exit('Missing appId');

if (is_post()) {
  csrf_check();
  $stmt = db()->prepare('INSERT INTO ad_units (appId, adUnitId, adType, network, isTestMode) VALUES (?,?,?,?,?)');
  $stmt->execute([$appId, $_POST['adUnitId'], $_POST['adType'], $_POST['network'], isset($_POST['isTestMode']) ? 1 : 0]);
  create_audit($_SESSION['user_id'], 'adunit_added', ['appId'=>$appId]);
  redirect('/adunits.php?appId=' . $appId);
}

$stmt = db()->prepare('SELECT * FROM ad_units WHERE appId = ? ORDER BY id DESC');
$stmt->execute([$appId]);
$units = $stmt->fetchAll();
?>
<?php include VIEW_ROOT . 'layout_header.php'; ?>
<h3>Ad Units</h3>
<form method="post" class="card card-body mb-3">
  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
  <div class="row g-2">
    <div class="col-md-4"><input class="form-control" name="adUnitId" placeholder="Ad Unit ID" required></div>
    <div class="col-md-3">
      <select class="form-select" name="adType">
        <option>banner</option><option>interstitial</option><option>rewarded</option><option>native</option>
      </select>
    </div>
    <div class="col-md-3">
      <select class="form-select" name="network">
        <option>AdMob</option><option>AudienceNetwork</option>
      </select>
    </div>
    <div class="col-md-2">
      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="isTestMode" id="isTest">
        <label class="form-check-label" for="isTest">Test Mode</label>
      </div>
    </div>
  </div>
  <button class="btn btn-primary mt-2">Add</button>
</form>

<div class="card">
  <div class="table-responsive">
    <table class="table table-striped mb-0">
      <thead><tr><th>ID</th><th>Type</th><th>Network</th><th>Ad Unit</th><th>Test</th></tr></thead>
      <tbody>
        <?php foreach ($units as $u): ?>
          <tr>
            <td><?= (int)$u['id'] ?></td>
            <td><?= e($u['adType']) ?></td>
            <td><?= e($u['network']) ?></td>
            <td><code><?= e($u['adUnitId']) ?></code></td>
            <td><?= $u['isTestMode'] ? 'Yes' : 'No' ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include VIEW_ROOT . 'layout_footer.php'; ?>
