<?php
// Simple .env loader (PHP 7 compatible)
function env($key, $default = null) {
    static $env = null;
    if ($env === null) {
        $env = [];
        $path = __DIR__ . '/../../.env';
        if (!file_exists($path)) {
            $path = __DIR__ . '/../../.env.example';
        }
        $lines = @file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        if ($lines) {
            foreach ($lines as $line) {
                $trimmed = trim($line);
                if ($trimmed === '' || strpos($trimmed, '#') === 0) continue;
                if (strpos($trimmed, '=') === false) continue;
                list($k, $v) = explode('=', $trimmed, 2);
                $k = trim($k);
                $v = trim($v);
                $v = trim($v, '\'" ');
                $env[$k] = $v;
            }
        }
    }
    return isset($env[$key]) ? $env[$key] : $default;
}

date_default_timezone_set('UTC');
session_name(env('SESSION_NAME', 'app_panel_session'));
if (session_status() === PHP_SESSION_NONE) { session_start(); }

define('APP_ROOT', __DIR__ . '/../../');
define('VIEW_ROOT', __DIR__ . '/../views/');
