# App Management Panel (PHP + MySQL)

A raw-PHP starter to manage Android apps with API integration: force update, ad networks (AdMob/Audience Network),
custom notifications, versioning, API keys, audit logs, password reset, and more.

## Quick Start

1. Create a MySQL database (e.g. `app_panel`).
2. Copy `.env.example` to `.env` and update credentials.
3. Import `migrations/schema.sql` into your database.
4. Serve `public/` via Apache/Nginx (ensure PHP 8.1+). For Apache, enable `mod_rewrite`.
5. Login with the seeded admin: **admin@example.com / Admin@12345** (please change immediately).
6. (Optional) Configure mail settings in `.env` for password resets.

## Notes

- API auth uses an `X-API-KEY` header per app.
- Admin web auth uses sessions + bcrypt.
- CSRF protection on all POST/PUT/DELETE forms.
- Very lightweight router; endpoints are simple PHP files.
- Use this as a foundation and extend to your needs.
